
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/tweety.zip" ),
}


local prefabs = {}

local start_inv = {"cane"}



local fn = function(inst)

inst.components.inventory:GuaranteeItems(start_inv)

inst.components.sanity:SetMax(200)

inst.components.hunger:SetMax(200)

inst.components.health:SetMaxHealth(200)

             

inst.soundsname =( "wolfgang" )	-- choose which sounds this character will play

inst.MiniMapEntity:SetIcon( "wilson.png" ) -- a minimap icon must be specified	

end






-- strings! Any "tweety" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.tweety = "Tweetybird"
STRINGS.CHARACTER_NAMES.tweety = "Tweety"
STRINGS.CHARACTER_DESCRIPTIONS.tweety = "* An example of how to create Tweety."
STRINGS.CHARACTER_QUOTES.tweety = "\"I am a Tweetybird.\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.Tweety = {}
STRINGS.CHARACTERS.Tweety.DESCRIBE = {}
STRINGS.CHARACTERS.Tweety.DESCRIBE.EVERGREEN = "Not a good tree to nest in."



return MakePlayerCharacter("tweety", prefabs, assets, fn, start_inv)
